IF EXISTS ( SELECT * FROM SYS.OBJECTS WHERE TYPE = 'TR' AND name = 'CT_Cbtes_CD_Clientes_Novedades_Upd')
BEGIN
    DROP TRIGGER dbo.CT_Cbtes_CD_Clientes_Novedades_Upd 
END
GO

CREATE TRIGGER [dbo].[CT_Cbtes_CD_Clientes_Novedades_Upd] ON [dbo].[Cbtes]
AFTER UPDATE
AS 
SET NOCOUNT ON
DECLARE @Id_Trans					INT
DECLARE @Item						SMALLINT
DECLARE @Id_Novedad_Pendiente		INT
DECLARE @Id_Cliente					INT
DECLARE @xParam_CD_Cli_Noved_Ejecut	INT

--INSERT y UPDATE estan separados los Trigger porque en Clarion mantiene todo en Memoria y luego graba todo junto.

SET @xParam_CD_Cli_Noved_Ejecut = ISNULL(CONVERT(INT, dbo.CF_xParam('CD_Cli_Noved_Ejecut')), 0)

IF (@xParam_CD_Cli_Noved_Ejecut <> 0)
BEGIN
	SET NOCOUNT ON
	DECLARE cur_CT_Cbtes_CD_Clientes_Novedades_Upd CURSOR FOR
	SELECT I.Id_Trans
	FROM Inserted I LEFT OUTER JOIN Deleted D ON I.Id_Trans = D.Id_Trans, Cbtes_Tipos CT
	WHERE
	ISNULL(I.Id_Tipo_Cbte, '')  = CT.Id_Tipo_Cbte
	AND ISNULL(CT.Compromete_Factura, 0) IN (1,-1)
	AND (
		(ISNULL(I.Id_Estado_Cbte, 0) <> ISNULL(D.Id_Estado_Cbte, 0)) OR
		(ISNULL(I.Saldo, 0) <> ISNULL(D.Saldo, 0))
		)

	OPEN cur_CT_Cbtes_CD_Clientes_Novedades_Upd
	FETCH NEXT FROM cur_CT_Cbtes_CD_Clientes_Novedades_Upd INTO @Id_Trans
	WHILE @@FETCH_STATUS = 0
	BEGIN
	
		--Recorro los items del Cbte
		DECLARE cur_CT_Cbtes_CD_Clientes_Novedades_Upd_Items CURSOR FOR
		SELECT Id_Trans, Item, ISNULL(Id_Cliente, 0)
		FROM Cbtes_Items
		WHERE 
		Id_Trans = @Id_Trans

		OPEN cur_CT_Cbtes_CD_Clientes_Novedades_Upd_Items
		FETCH NEXT FROM cur_CT_Cbtes_CD_Clientes_Novedades_Upd_Items INTO @Id_Trans, @Item, @Id_Cliente
		WHILE @@FETCH_STATUS = 0
		BEGIN		
	
			SET @Id_Novedad_Pendiente = ISNULL(	(SELECT MAX(Id_Novedad)
												FROM CD_Clientes_Novedades
												WHERE
												Estado = 'P'
												AND Id_Cliente = @Id_Cliente)
												, 0)
			IF(@Id_Novedad_Pendiente > 0)
			BEGIN
				UPDATE CD_Clientes_Novedades
				SET
				Fecha = GETDATE()
				WHERE
				Estado = 'P'
				AND Id_Cliente = @Id_Cliente
			END
			ELSE
			BEGIN
				INSERT INTO CD_Clientes_Novedades
				(Id_Cliente,		Fecha,		Estado)
				VALUES
				(@Id_Cliente,		GETDATE(),	'P')
			END
		  
			FETCH NEXT FROM cur_CT_Cbtes_CD_Clientes_Novedades_Upd_Items INTO @Id_Trans, @Item, @Id_Cliente
		END
		CLOSE cur_CT_Cbtes_CD_Clientes_Novedades_Upd_Items
		DEALLOCATE cur_CT_Cbtes_CD_Clientes_Novedades_Upd_Items
		--FIN Recorro los items del Cbte

		FETCH NEXT FROM cur_CT_Cbtes_CD_Clientes_Novedades_Upd INTO @Id_Trans
	END
	CLOSE cur_CT_Cbtes_CD_Clientes_Novedades_Upd
	DEALLOCATE cur_CT_Cbtes_CD_Clientes_Novedades_Upd
END
